#ifndef SYMBOLMODE_H
#define SYMBOLMODE_H

// bmp width & height
#define W_MODE    40
#define H_MODE    32
#define W_MODE_SM 19
#define H_MODE_SM 14
// y offset from Y_DIGIT_LG
#define OFFSET_MODE_LG 0
// y offset from Y_DIGIT_SM
#define OFFSET_MODE_SM 0

#define W_LOBATT  36
#define H_LOBATT  16

#define W_SET_Z   64
#define H_SET_Z   32

#define MODE_NONE 0
#define MODE_DC   1
#define MODE_AC   2
#define MODE_REL  3

#define MODE_LG(n) (n?(uint8_t*)pgm_read_word(&(symbolMode[n-1])):MODE_NONE)
#define MODE_SM(n) (n?(uint8_t*)pgm_read_word(&(symbolMode_sm[n-1])):MODE_NONE)

// DC
const uint8_t symbolMode_0[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x3F, 0xE0, 0x00, 0x3E,
  0x00, 0x3F, 0xF0, 0x00, 0xFF,
  0x00, 0x3F, 0xF8, 0x01, 0xFF,
  0x00, 0x3C, 0x7C, 0x03, 0xE1,
  0x00, 0x3C, 0x3E, 0x03, 0xC0,
  0x00, 0x3C, 0x1E, 0x07, 0x80,
  0x00, 0x3C, 0x1E, 0x07, 0x80,
  0x00, 0x3C, 0x1E, 0x07, 0x80,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0F, 0x0F, 0x00,
  0x00, 0x3C, 0x0E, 0x07, 0x80,
  0x00, 0x3C, 0x1E, 0x07, 0x80,
  0x00, 0x3C, 0x1E, 0x07, 0x80,
  0x00, 0x3C, 0x3E, 0x03, 0xC0,
  0x00, 0x3C, 0x7C, 0x03, 0xE1,
  0x00, 0x3F, 0xF8, 0x01, 0xFF,
  0x00, 0x3F, 0xF0, 0x00, 0xFF,
  0x00, 0x3F, 0xC0, 0x00, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x00
};
// AC
const uint8_t symbolMode_1[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0xE0, 0x00, 0x3E,
  0x00, 0x00, 0xF0, 0x00, 0xFF,
  0x00, 0x00, 0xF0, 0x01, 0xFF,
  0x00, 0x00, 0xF0, 0x03, 0xE1,
  0x00, 0x01, 0xF0, 0x03, 0xC0,
  0x00, 0x01, 0xF0, 0x07, 0x80,
  0x00, 0x01, 0xF8, 0x07, 0x80,
  0x00, 0x01, 0xF8, 0x07, 0x80,
  0x00, 0x03, 0xB8, 0x0F, 0x00,
  0x00, 0x03, 0xB8, 0x0F, 0x00,
  0x00, 0x03, 0xBC, 0x0F, 0x00,
  0x00, 0x03, 0xBC, 0x0F, 0x00,
  0x00, 0x03, 0x9C, 0x0F, 0x00,
  0x00, 0x07, 0x9C, 0x0F, 0x00,
  0x00, 0x07, 0x1C, 0x0F, 0x00,
  0x00, 0x07, 0x1E, 0x0F, 0x00,
  0x00, 0x07, 0x1E, 0x0F, 0x00,
  0x00, 0x07, 0x0E, 0x0F, 0x00,
  0x00, 0x0F, 0x0E, 0x0F, 0x00,
  0x00, 0x0F, 0x0E, 0x0F, 0x00,
  0x00, 0x0F, 0xFF, 0x0F, 0x00,
  0x00, 0x0F, 0xFF, 0x07, 0x80,
  0x00, 0x1F, 0xFF, 0x07, 0x80,
  0x00, 0x1E, 0x07, 0x07, 0x80,
  0x00, 0x1E, 0x07, 0x03, 0xC0,
  0x00, 0x1C, 0x07, 0x83, 0xE1,
  0x00, 0x1C, 0x07, 0x81, 0xFF,
  0x00, 0x3C, 0x07, 0x80, 0xFF,
  0x00, 0x3C, 0x03, 0x80, 0x3E,
  0x00, 0x00, 0x00, 0x00, 0x00
};
// Rel
const uint8_t symbolMode_2[] PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00,
  0xFF, 0x00, 0xFF, 0xC3, 0xC0,
  0xFF, 0xC0, 0xFF, 0xC3, 0xC0,
  0xFF, 0xE0, 0xFF, 0xC3, 0xC0,
  0xF1, 0xE0, 0xF0, 0x03, 0xC0,
  0xF1, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF1, 0xE0, 0xF0, 0x03, 0xC0,
  0xF7, 0xE0, 0xF0, 0x03, 0xC0,
  0xFF, 0xC0, 0xFF, 0xC3, 0xC0,
  0xFF, 0x80, 0xFF, 0xC3, 0xC0,
  0xFF, 0x00, 0xFF, 0xC3, 0xC0,
  0xF7, 0x80, 0xF0, 0x03, 0xC0,
  0xF7, 0x80, 0xF0, 0x03, 0xC0,
  0xF7, 0x80, 0xF0, 0x03, 0xC0,
  0xF3, 0xC0, 0xF0, 0x03, 0xC0,
  0xF3, 0xC0, 0xF0, 0x03, 0xC0,
  0xF3, 0xC0, 0xF0, 0x03, 0xC0,
  0xF1, 0xE0, 0xF0, 0x03, 0xC0,
  0xF1, 0xE0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xF0, 0x03, 0xC0,
  0xF0, 0xF0, 0xFF, 0xC3, 0xFF,
  0xF0, 0x78, 0xFF, 0xC3, 0xFF,
  0xF0, 0x78, 0xFF, 0xC3, 0xFF,
  0x00, 0x00, 0x00, 0x00, 0x00
};

const uint8_t * const symbolMode[3] PROGMEM = {
  symbolMode_0,
  symbolMode_1,
  symbolMode_2
};

// DC
const uint8_t symbolMode_sm_0[] PROGMEM =
  { 0xFC, 0x03, 0x80,
    0xFE, 0x07, 0xC0,
    0xC3, 0x0C, 0x60,
    0xC3, 0x0C, 0x60,
    0xC1, 0x98, 0x00,
    0xC1, 0x98, 0x00,
    0xC1, 0x98, 0x00,
    0xC1, 0x98, 0x00,
    0xC1, 0x98, 0x00,
    0xC1, 0x98, 0x00,
    0xC3, 0x0C, 0x60,
    0xC3, 0x0C, 0x60,
    0xFE, 0x07, 0xC0,
    0xFC, 0x03, 0x80 };
// AC
const uint8_t symbolMode_sm_1[] PROGMEM =
  { 0x1C, 0x03, 0x80,
    0x1C, 0x07, 0xC0,
    0x3E, 0x0C, 0x60,
    0x36, 0x0C, 0x60,
    0x36, 0x18, 0x00,
    0x63, 0x18, 0x00,
    0x63, 0x18, 0x00,
    0x63, 0x18, 0x00,
    0x7F, 0x18, 0x00,
    0xFF, 0x98, 0x00,
    0xC1, 0x8C, 0x60,
    0xC1, 0x8C, 0x60,
    0xC1, 0x87, 0xC0,
    0xC1, 0x83, 0x80 };

const uint8_t * const symbolMode_sm[2] PROGMEM = {
  symbolMode_sm_0,
  symbolMode_sm_1
};

const uint8_t symbolLoBatt[] PROGMEM = 
  { 0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
    0xC0, 0x00, 0x00, 0x00, 0xC0,
    0xDF, 0xFF, 0xE0, 0x00, 0xC0,
    0xDF, 0xFF, 0xE0, 0x00, 0xCD,
    0xDF, 0xFF, 0xF0, 0x00, 0xC5,
    0xDF, 0xFF, 0xF0, 0x00, 0xF3,
    0xDF, 0xFF, 0xF8, 0x00, 0xFF,
    0xDF, 0xFF, 0xF8, 0x00, 0xF3,
    0xDF, 0xFF, 0xFC, 0x00, 0xF7,
    0xDF, 0xFF, 0xFC, 0x00, 0xCB,
    0xDF, 0xFF, 0xFE, 0x00, 0xC5,
    0xDF, 0xFF, 0xFE, 0x00, 0xCC,
    0xC0, 0x00, 0x00, 0x00, 0xC5,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0,
    0xFF, 0xFF, 0xFF, 0xFF, 0xC0 };
    
const uint8_t symbolSetZ[] PROGMEM =
  { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x0F, 0xC0, 0xFF, 0xE7, 0xFF, 0xE0, 0x1F, 0xFF,
    0x3F, 0xE0, 0xFF, 0xE7, 0xFF, 0xE0, 0x1F, 0xFE,
    0x7F, 0xE0, 0xFF, 0xE7, 0xFF, 0xE0, 0x1F, 0xFE,
    0x7C, 0x60, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x3E,
    0xF8, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x3C,
    0xF0, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x3C,
    0xF0, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x7C,
    0xF0, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x78,
    0xF0, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0x78,
    0xF8, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0xF8,
    0xF8, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0xF0,
    0x7C, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x00, 0xF0,
    0x7E, 0x00, 0xF0, 0x00, 0x3C, 0x00, 0x01, 0xF0,
    0x3F, 0x00, 0xFF, 0xC0, 0x3C, 0x00, 0x01, 0xE0,
    0x1F, 0x80, 0xFF, 0xC0, 0x3C, 0x00, 0x01, 0xE0,
    0x0F, 0xC0, 0xFF, 0xC0, 0x3C, 0x00, 0x03, 0xE0,
    0x07, 0xE0, 0xF0, 0x00, 0x3C, 0x00, 0x03, 0xC0,
    0x03, 0xF0, 0xF0, 0x00, 0x3C, 0x00, 0x03, 0xC0,
    0x01, 0xF0, 0xF0, 0x00, 0x3C, 0x00, 0x07, 0xC0,
    0x00, 0xF8, 0xF0, 0x00, 0x3C, 0x00, 0x07, 0x80,
    0x00, 0x78, 0xF0, 0x00, 0x3C, 0x00, 0x07, 0x80,
    0x00, 0x78, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x80,
    0x00, 0x78, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00,
    0x00, 0x78, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00,
    0xC0, 0x78, 0xF0, 0x00, 0x3C, 0x00, 0x1F, 0x00,
    0xE0, 0xF0, 0xF0, 0x00, 0x3C, 0x00, 0x1E, 0x00,
    0xF1, 0xF0, 0xF0, 0x00, 0x3C, 0x00, 0x1E, 0x00,
    0x7F, 0xE0, 0xFF, 0xE0, 0x3C, 0x00, 0x3F, 0xFE,
    0x3F, 0xC0, 0xFF, 0xE0, 0x3C, 0x00, 0x3F, 0xFE,
    0x1F, 0x80, 0xFF, 0xE0, 0x3C, 0x00, 0x3F, 0xFE,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };

#endif // SYMBOLMODE_H
