#ifndef DIGIT_TINY_H
#define DIGIT_TINY_H

// digit width & height
#define W_DIGIT_TINY 8
#define H_DIGIT_TINY 13


#define DIGIT_TINY(n) (n<10?(uint8_t*)pgm_read_word(&(digit_tiny[n])):0)

// 0
const uint8_t digit_tiny_0[] PROGMEM = {
  0x38,
  0x44,
  0x82,
  0x82,
  0x82,
  0x82,
  0x82,
  0x82,
  0x82,
  0x82,
  0x82,
  0x44,
  0x38
};
// 1
const uint8_t digit_tiny_1[] PROGMEM = {
  0x08,
  0x08,
  0x18,
  0x28,
  0x48,
  0x08,
  0x08,
  0x08,
  0x08,
  0x08,
  0x08,
  0x08,
  0x08
};
// 2
const uint8_t digit_tiny_2[] PROGMEM = {
  0x38,
  0x44,
  0x82,
  0x82,
  0x02,
  0x02,
  0x04,
  0x08,
  0x10,
  0x20,
  0x40,
  0x80,
  0xFE
};
// 3
const uint8_t digit_tiny_3[] PROGMEM = {
  0x38,
  0x44,
  0x82,
  0x02,
  0x02,
  0x04,
  0x18,
  0x04,
  0x02,
  0x82,
  0x82,
  0x44,
  0x38
};
// 4
const uint8_t digit_tiny_4[] PROGMEM = {
  0x04,
  0x04,
  0x0C,
  0x0C,
  0x14,
  0x24,
  0x24,
  0x44,
  0x84,
  0xFE,
  0x04,
  0x04,
  0x04
};
// 5
const uint8_t digit_tiny_5[] PROGMEM = {
  0x7E,
  0x40,
  0x40,
  0x80,
  0xF8,
  0xC4,
  0x82,
  0x02,
  0x02,
  0x82,
  0x82,
  0x44,
  0x38
};
// 6
const uint8_t digit_tiny_6[] PROGMEM = {
  0x3C,
  0x42,
  0x82,
  0x80,
  0x80,
  0xB8,
  0xC4,
  0x82,
  0x82,
  0x82,
  0x82,
  0x44,
  0x38
};
// 7
const uint8_t digit_tiny_7[] PROGMEM = {
  0xFE,
  0x02,
  0x04,
  0x08,
  0x08,
  0x10,
  0x10,
  0x20,
  0x20,
  0x20,
  0x40,
  0x40,
  0x40
};
// 8
const uint8_t digit_tiny_8[] PROGMEM = {
  0x38,
  0x44,
  0x82,
  0x82,
  0x82,
  0x44,
  0x38,
  0x44,
  0x82,
  0x82,
  0x82,
  0x44,
  0x38
};
// 9
const uint8_t digit_tiny_9[] PROGMEM = {
  0x38,
  0x44,
  0x82,
  0x82,
  0x82,
  0x82,
  0x46,
  0x3A,
  0x02,
  0x02,
  0x82,
  0x84,
  0x78
};

const uint8_t * const digit_tiny[10] PROGMEM = {
  digit_tiny_0,
  digit_tiny_1,
  digit_tiny_2,
  digit_tiny_3,
  digit_tiny_4,
  digit_tiny_5,
  digit_tiny_6,
  digit_tiny_7,
  digit_tiny_8,
  digit_tiny_9
};

#endif // DIGIT_TINY_H
