#ifndef DIGIT_SM_H
#define DIGIT_SM_H

// digit width & height
#define W_DIGIT_SM 16
#define H_DIGIT_SM 32
// dp width & height
#define W_DP_SM 4
#define H_DP_SM 32


#define DIGIT_SM(n) (n<10?(uint8_t*)pgm_read_word(&(digit_sm[n])):0)

// 0
const uint8_t digit_sm_0[] PROGMEM = {
  0x07, 0xC0,
  0x0F, 0xF0,
  0x1F, 0xF8,
  0x1F, 0xF8,
  0x3E, 0x7C,
  0x3C, 0x3C,
  0x3C, 0x3C,
  0x38, 0x1C,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x38, 0x1C,
  0x3C, 0x3C,
  0x3C, 0x3C,
  0x3C, 0x3C,
  0x1E, 0x78,
  0x1F, 0xF8,
  0x0F, 0xF0,
  0x07, 0xE0
};
// 1
const uint8_t digit_sm_1[] PROGMEM = {
  0x0F, 0xE0,
  0x0F, 0xE0,
  0x0F, 0xE0,
  0x0F, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x01, 0xE0
};
// 2
const uint8_t digit_sm_2[] PROGMEM = {
  0x07, 0xE0,
  0x1F, 0xF8,
  0x3F, 0xFC,
  0x3F, 0xFC,
  0x3C, 0x3E,
  0x7C, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x78, 0x1E,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x7C,
  0x00, 0x78,
  0x00, 0xF8,
  0x00, 0xF0,
  0x00, 0xF0,
  0x01, 0xF0,
  0x01, 0xE0,
  0x03, 0xE0,
  0x03, 0xC0,
  0x07, 0xC0,
  0x07, 0x80,
  0x0F, 0x00,
  0x0F, 0x00,
  0x1E, 0x00,
  0x1F, 0xFE,
  0x3F, 0xFE,
  0x3F, 0xFE,
  0x7F, 0xFE
};
// 3
const uint8_t digit_sm_3[] PROGMEM = {
  0x07, 0xE0,
  0x0F, 0xF8,
  0x1F, 0xFC,
  0x1F, 0xFC,
  0x3E, 0x3E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x3E,
  0x00, 0xFC,
  0x03, 0xF8,
  0x03, 0xE0,
  0x03, 0xF8,
  0x00, 0x7C,
  0x00, 0x3E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x3E,
  0x3E, 0x3C,
  0x1F, 0xFC,
  0x1F, 0xFC,
  0x0F, 0xF8,
  0x07, 0xE0
};
// 4
const uint8_t digit_sm_4[] PROGMEM = {
  0x00, 0x3C,
  0x00, 0x7C,
  0x00, 0x7C,
  0x00, 0xFC,
  0x00, 0xFC,
  0x00, 0xFC,
  0x01, 0xFC,
  0x01, 0xFC,
  0x03, 0xBC,
  0x03, 0xBC,
  0x07, 0x3C,
  0x07, 0x3C,
  0x0F, 0x3C,
  0x0E, 0x3C,
  0x0E, 0x3C,
  0x1C, 0x3C,
  0x1C, 0x3C,
  0x3C, 0x3C,
  0x38, 0x3C,
  0x78, 0x3C,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x7F, 0xFF,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x3C
};
// 5
const uint8_t digit_sm_5[] PROGMEM = {
  0x07, 0xFE,
  0x07, 0xFE,
  0x07, 0xFE,
  0x07, 0xFE,
  0x07, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0F, 0x00,
  0x0E, 0x00,
  0x0E, 0x00,
  0x0F, 0xE0,
  0x1F, 0xF0,
  0x1F, 0xF8,
  0x1F, 0xFC,
  0x00, 0xFC,
  0x00, 0x3E,
  0x00, 0x3E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x1E,
  0x00, 0x3C,
  0x00, 0x3C,
  0x10, 0xFC,
  0x3F, 0xF8,
  0x3F, 0xF8,
  0x3F, 0xF0,
  0x0F, 0xC0
};
// 6
const uint8_t digit_sm_6[] PROGMEM = {
  0x00, 0xF0,
  0x01, 0xF0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x03, 0xC0,
  0x03, 0xC0,
  0x07, 0x80,
  0x07, 0x80,
  0x0F, 0x80,
  0x0F, 0x00,
  0x0F, 0x00,
  0x1E, 0x00,
  0x1E, 0xF0,
  0x1F, 0xF8,
  0x1F, 0xFC,
  0x3F, 0xFC,
  0x3E, 0x3E,
  0x3E, 0x3E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3E, 0x3E,
  0x1E, 0x3C,
  0x1F, 0xFC,
  0x0F, 0xFC,
  0x0F, 0xF8,
  0x03, 0xE0
};
// 7
const uint8_t digit_sm_7[] PROGMEM = {
  0x3F, 0xFF,
  0x3F, 0xFF,
  0x3F, 0xFE,
  0x3F, 0xFE,
  0x00, 0x1E,
  0x00, 0x3E,
  0x00, 0x3C,
  0x00, 0x3C,
  0x00, 0x7C,
  0x00, 0x78,
  0x00, 0x78,
  0x00, 0xF8,
  0x00, 0xF0,
  0x00, 0xF0,
  0x00, 0xF0,
  0x01, 0xF0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x03, 0xE0,
  0x03, 0xC0,
  0x03, 0xC0,
  0x07, 0xC0,
  0x07, 0x80,
  0x07, 0x80,
  0x0F, 0x80,
  0x0F, 0x80,
  0x0F, 0x00,
  0x1F, 0x00,
  0x1F, 0x00,
  0x1E, 0x00,
  0x1E, 0x00,
  0x3E, 0x00
};
// 8
const uint8_t digit_sm_8[] PROGMEM = {
  0x07, 0xF0,
  0x0F, 0xF8,
  0x1F, 0xFC,
  0x1F, 0xFC,
  0x3E, 0x3E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x1E, 0x3C,
  0x0F, 0xF8,
  0x07, 0xF0,
  0x0F, 0xF8,
  0x1F, 0xFC,
  0x1E, 0x3C,
  0x3E, 0x3E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3E, 0x3E,
  0x1E, 0x3C,
  0x1F, 0xFC,
  0x1F, 0xFC,
  0x0F, 0xF8,
  0x03, 0xE0
};
// 9
const uint8_t digit_sm_9[] PROGMEM = {
  0x03, 0xE0,
  0x0F, 0xF8,
  0x1F, 0xF8,
  0x1F, 0xFC,
  0x1E, 0x3C,
  0x3E, 0x3E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3C, 0x1E,
  0x3E, 0x3E,
  0x3E, 0x3E,
  0x1F, 0xFE,
  0x1F, 0xFC,
  0x0F, 0xFC,
  0x07, 0xBC,
  0x00, 0x3C,
  0x00, 0x78,
  0x00, 0x78,
  0x00, 0xF0,
  0x00, 0xF0,
  0x01, 0xF0,
  0x01, 0xE0,
  0x01, 0xE0,
  0x03, 0xC0,
  0x03, 0xC0,
  0x07, 0x80,
  0x0F, 0x80
};

const uint8_t * const digit_sm[10] PROGMEM = {
  digit_sm_0,
  digit_sm_1,
  digit_sm_2,
  digit_sm_3,
  digit_sm_4,
  digit_sm_5,
  digit_sm_6,
  digit_sm_7,
  digit_sm_8,
  digit_sm_9
};

const uint8_t dp_sm[] PROGMEM = {
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x00,
  0x60,
  0xF0,
  0xF0,
  0x60
};

#endif // DIGIT_SM_H
